import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 12))

# Define grid size
rows, cols = 6, 4
cell_size = 1

# Define colors for pieces
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'lightgrey'
}

# Define positions for pieces
positions = {
    'rightl0': [(3, 0), (3, 1), (2, 0)],
    'rightl1': [(1, 0), (1, 1), (0, 0)],
    'square0': [(1, 2)],
    'square1': [(2, 2)],
    'clear': [(5, 0), (5, 1), (5, 2), (5, 3),
              (4, 0), (4, 1), (4, 2), (4, 3),
              (3, 2), (3, 3),
              (2, 1), (2, 3),
              (1, 3),
              (0, 1), (0, 2), (0, 3)]
}

# Draw grid cells
for r in range(rows):
    for c in range(cols):
        if (r, c) in positions['clear']:
            color = colors['clear']
            label = 'clear'
        else:
            color = 'white'
            label = ''
        ax.add_patch(patches.Rectangle((c, rows - r - 1), cell_size, cell_size,
                                       edgecolor='black', facecolor=color, linewidth=1))
        ax.text(c + 0.5, rows - r - 0.5, f'f{r}-{c}f\n{label}',
                ha='center', va='center', fontsize=8, color='black')

# Function to draw pieces
def draw_piece(name, pos_list, color):
    for (r, c) in pos_list:
        ax.add_patch(patches.Rectangle((c, rows - r - 1), cell_size, cell_size,
                                       edgecolor='black', facecolor=color, linewidth=3))
        ax.text(c + 0.5, rows - r - 0.7, name, ha='center', va='center', fontsize=8, color='black')
        ax.text(c + 0.5, rows - r - 0.3, 'occupied', ha='center', va='center', fontsize=8, color='black')

# Draw each piece
for piece, pos_list in positions.items():
    if piece != 'clear':
        draw_piece(piece, pos_list, colors[piece])

# Set limits and aspect
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.axis('off')

# Create a legend
legend_elements = [patches.Patch(facecolor=colors['rightl0'], edgecolor='black', label='Right-L0 (Occupied)'),
                   patches.Patch(facecolor=colors['rightl1'], edgecolor='black', label='Right-L1 (Occupied)'),
                   patches.Patch(facecolor=colors['square0'], edgecolor='black', label='Square0 (Occupied)'),
                   patches.Patch(facecolor=colors['square1'], edgecolor='black', label='Square1 (Occupied)'),
                   patches.Patch(facecolor=colors['clear'], edgecolor='black', label='Clear')]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_16.png', bbox_inches='tight')
plt.show()